/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZAE;
import com.aspose.words.internal.zzZBZ;
import com.aspose.words.internal.zzZCR;
import com.aspose.words.internal.zzZDA;
import com.aspose.words.internal.zzZDM;
import com.aspose.words.internal.zzZDN;
import com.aspose.words.internal.zzZRJ;
import com.aspose.words.internal.zzZRV;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzZC0
extends CertPathValidatorSpi {
    private final Provider zzWYO;

    zzZC0(Provider provider) {
        this.zzWYO = provider;
    }

    @Override
    public final CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        int n;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        zzZDM zzZDM2;
        if (params instanceof zzZDM) {
            zzZDM2 = (zzZDM)params;
        } else if (params instanceof zzZDN) {
            zzZDM2 = ((zzZDN)params).zzYW2();
        } else if (params instanceof PKIXParameters) {
            zzZDM2 = new zzZDM.zzZ((PKIXParameters)params).zzYVS();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + zzZDM.class.getName() + " instance.");
        }
        if (zzZDM2.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = zzZDM2.getInitialPolicies();
        try {
            trustAnchor = zzZCR.zzZ((X509Certificate)list.get(list.size() - 1), zzZDM2.getTrustAnchors(), zzZDM2.getSigProvider());
        }
        catch (zzZDA zzZDA2) {
            throw new CertPathValidatorException(zzZDA2.getMessage(), (Throwable)zzZDA2, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        zzZDM2 = new zzZDM.zzZ(zzZDM2).zzZ(trustAnchor).zzYVS();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        zzZBZ zzZBZ2 = new zzZBZ(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(zzZBZ2);
        zzZRJ zzZRJ2 = new zzZRJ();
        HashSet hashSet3 = new HashSet();
        int n3 = zzZDM2.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n4 = zzZDM2.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n5 = zzZDM2.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = zzZCR.zzY(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        try {
            zzZCR.zzZ(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        int n6 = n2;
        if (zzZDM2.zzYVT() != null && !zzZDM2.zzYVT().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = zzZDM2.getCertPathCheckers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n = list.size() - 1; n >= 0; --n) {
            boolean bl;
            int n7 = n2 - n;
            x509Certificate2 = (X509Certificate)list.get(n);
            boolean bl2 = bl = n == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n);
            }
            zzZAE.zzZ(certPath, zzZDM2, n, publicKey, bl, x500Principal, x509Certificate, this.zzWYO);
            zzZAE.zzZ(certPath, n, zzZRJ2);
            zzZBZ2 = zzZAE.zzZ(certPath, n, hashSet3, zzZBZ2, listArray, n4);
            zzZBZ2 = zzZAE.zzZ(certPath, n, zzZBZ2);
            zzZAE.zzZ(certPath, n, zzZBZ2, n3);
            if (n7 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n);
            }
            zzZAE.zzZ(certPath, n);
            zzZBZ2 = zzZAE.zzZ(certPath, n, listArray, zzZBZ2, n5);
            zzZAE.zzY(certPath, n, zzZRJ2);
            n3 = zzZAE.zzU(certPath, n, n3);
            n5 = zzZAE.zzT(certPath, n, n5);
            n4 = zzZAE.zzS(certPath, n, n4);
            n3 = zzZAE.zzZ(certPath, n, n3);
            n5 = zzZAE.zzY(certPath, n, n5);
            n4 = zzZAE.zzX(certPath, n, n4);
            zzZAE.zzY(certPath, n);
            n6 = zzZAE.zzW(certPath, n, n6);
            n6 = zzZAE.zzV(certPath, n, n6);
            zzZAE.zzX(certPath, n);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(zzZAE.zzWVO);
            } else {
                hashSet = new HashSet();
            }
            zzZAE.zzZ(certPath, n, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = zzZCR.zzY(x509Certificate);
            try {
                publicKey = zzZCR.zzZ(certPath.getCertificates(), n, this.zzWYO);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n);
            }
            zzZCR.zzZ(publicKey);
        }
        n3 = zzZAE.zzZ(n3, x509Certificate2);
        n3 = zzZAE.zzR(certPath, n + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(zzZAE.zzWVO);
            set2.remove(zzZRV.zzXsN.getId());
        } else {
            set2 = new HashSet<String>();
        }
        zzZAE.zzZ(certPath, n + 1, list2, set2);
        hashSet = zzZAE.zzZ(certPath, zzZDM2, set, n + 1, listArray, zzZBZ2, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n);
    }
}

