/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BorderCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSize;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ShapeBase;
import com.aspose.words.internal.zz74;
import com.aspose.words.internal.zz76;
import com.aspose.words.internal.zz77;
import com.aspose.words.internal.zz8H;
import com.aspose.words.internal.zzNM;
import com.aspose.words.internal.zzU1;
import com.aspose.words.internal.zzW;
import com.aspose.words.internal.zzYH;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zz6V;
import com.aspose.words.zzZO1;
import com.aspose.words.zzZO2;
import com.aspose.words.zzZOI;
import com.aspose.words.zzZRX;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageData
implements zzZRX {
    private ShapeBase zzYV2;
    private BorderCollection zzYV1;
    private static zz8H<Integer, Integer> zzYV0 = new zz8H<Integer, Integer>();
    private zzZO2 zzYUZ;

    ImageData(ShapeBase parent, Document doc) {
        this.zzYV2 = parent;
        this.zzYUZ = parent.getMarkupLanguage() == 1 ? new zzZO2(doc, new zzZO1(parent), new zzZOI()) : new zzZO2(doc, new zz6V(parent), new zzZOI());
    }

    public void setImage(BufferedImage image) throws Exception {
        BufferedImage bufferedImage = image;
        zzZO2 zzZO22 = this.zzYUZ;
        if (bufferedImage == null) {
            throw new NullPointerException("image");
        }
        zz76 zz762 = new zz76();
        try {
            zzYH.zzZ(bufferedImage, zz762);
            zzZO22.zz1(zz762);
            return;
        }
        finally {
            zz762.close();
        }
    }

    public void setImage(InputStream stream) throws Exception {
        this.zz1(zzW.zzZ(stream));
    }

    final void zz1(zz74 zz742) throws Exception {
        this.zzYUZ.zz1(zz742);
    }

    public void setImage(String fileName) throws Exception {
        this.zzYUZ.setImage(fileName);
    }

    public BufferedImage toImage() throws Exception {
        zzZO2 zzZO22 = this.zzYUZ;
        return zzYH.zzT(zzZO22.zzZLW());
    }

    public InputStream toStream() throws Exception {
        ImageData imageData = this;
        return zz74.zzg(imageData.zzYUZ.zzZLW());
    }

    public byte[] toByteArray() throws Exception {
        return this.zzYUZ.toByteArray();
    }

    public void save(OutputStream stream) throws Exception {
        zz76 zz762;
        zz76 zz763 = zz762 = new zz76();
        ImageData imageData = this;
        imageData.zzYUZ.zzP(zz763);
        zz762.zzx(0L);
        zzW.zzZ(zz762, stream);
    }

    public void save(String fileName) throws Exception {
        String string = fileName;
        zzZO2 zzZO22 = this.zzYUZ;
        zzZ.zzZ(string, "fileName");
        zz77 zz772 = zzZ.zzU(string);
        try {
            zzZO22.zzP(zz772);
            return;
        }
        finally {
            ((zz74)zz772).close();
        }
    }

    public byte[] getImageBytes() throws Exception {
        return this.zzYUZ.getImageBytes();
    }

    public void setImageBytes(byte[] value) throws Exception {
        this.zzYUZ.setImageBytes(value);
    }

    public boolean hasImage() throws Exception {
        zzZO2 zzZO22 = this.zzYUZ;
        return zzZO22.zzZLZ() || zzZO22.isLink();
    }

    public ImageSize getImageSize() throws Exception {
        return this.zzYUZ.getImageSize();
    }

    public int getImageType() throws Exception {
        zzZO2 zzZO22 = this.zzYUZ;
        return FileFormatUtil.zzKP(zzZO22.zzZLY());
    }

    final boolean zzZd(byte[] byArray) throws Exception {
        return this.zzYUZ.zzZd(byArray);
    }

    public boolean isLink() throws Exception {
        return this.zzYUZ.isLink();
    }

    public boolean isLinkOnly() throws Exception {
        zzZO2 zzZO22 = this.zzYUZ;
        return zzZO22.isLink() && !zzZO22.zzZLZ();
    }

    public String getSourceFullName() throws Exception {
        return this.zzYUZ.getSourceFullName();
    }

    public void setSourceFullName(String value) throws Exception {
        this.zzYUZ.setSourceFullName(value);
    }

    public String getTitle() {
        return (String)this.zzTJ(4103);
    }

    public void setTitle(String value) {
        zzZ.zzZ((Object)value, "value");
        this.zzT(4103, value);
    }

    public double getCropTop() {
        return this.zzYV2.zzZiG().getCropTop();
    }

    public void setCropTop(double value) {
        this.zzYV2.zzZiG().setCropTop(value);
    }

    public double getCropBottom() {
        return this.zzYV2.zzZiG().getCropBottom();
    }

    public void setCropBottom(double value) {
        this.zzYV2.zzZiG().setCropBottom(value);
    }

    public double getCropLeft() {
        return this.zzYV2.zzZiG().getCropLeft();
    }

    public void setCropLeft(double value) {
        this.zzYV2.zzZiG().setCropLeft(value);
    }

    public double getCropRight() {
        return this.zzYV2.zzZiG().getCropRight();
    }

    public void setCropRight(double value) {
        this.zzYV2.zzZiG().setCropRight(value);
    }

    final zzNM zzZI() {
        return new zzNM(this.getCropLeft(), this.getCropRight(), this.getCropTop(), this.getCropBottom());
    }

    public BorderCollection getBorders() {
        if (this.zzYV1 == null) {
            this.zzYV1 = new BorderCollection(this);
        }
        return this.zzYV1;
    }

    public Color getChromaKey() {
        return this.zzZM1().zzUJ();
    }

    public void setChromaKey(Color value) {
        zzU1 zzU12 = zzU1.zzZ(value);
        ImageData imageData = this;
        imageData.zzT(263, zzU12);
    }

    final zzU1 zzZM1() {
        return (zzU1)this.zzTJ(263);
    }

    public double getBrightness() {
        return this.zzYV2.zzZiG().getBrightness();
    }

    public void setBrightness(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Parameter name: value");
        }
        this.zzYV2.zzZiG().setBrightness(value);
    }

    public double getContrast() {
        return this.zzYV2.zzZiG().getContrast();
    }

    public void setContrast(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Parameter name: value");
        }
        this.zzYV2.zzZiG().setContrast(value);
    }

    public boolean getBiLevel() {
        return this.zzYV2.zzZiG().getBiLevel();
    }

    public void setBiLevel(boolean value) {
        this.zzYV2.zzZiG().setBiLevel(value);
    }

    public boolean getGrayScale() {
        return this.zzYV2.zzZiG().getGrayScale();
    }

    public void setGrayScale(boolean value) {
        this.zzYV2.zzZiG().setGrayScale(value);
    }

    static double zzYh(double d) {
        if (d < -0.5 || d > 0.5) {
            throw new IllegalArgumentException("Parameter name: escherBrightness");
        }
        return d + 0.5;
    }

    static double zzYg(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Parameter name: percent");
        }
        return d - 0.5;
    }

    static double zzYf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Parameter name: escherContrast");
        }
        if (d <= 1.0) {
            return d / 2.0;
        }
        return (d - 0.5) / d;
    }

    static double zzYe(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Parameter name: percent");
        }
        if (d <= 0.5) {
            return d * 2.0;
        }
        if (d < 1.0) {
            return 0.5 / (1.0 - d);
        }
        return Double.MAX_VALUE;
    }

    final boolean zzZM0() {
        return this.zzYV2.getDirectShapeAttr(263) != null;
    }

    final boolean zzZLZ() throws Exception {
        return this.getImageBytes() != null && this.getImageBytes().length > 0;
    }

    final int zzZLY() throws Exception {
        return this.zzYUZ.zzZLY();
    }

    private Object zzTJ(int n) {
        return this.zzYV2.fetchShapeAttr(n);
    }

    private void zzT(int n, Object object) {
        this.zzYV2.setShapeAttr(n, object);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectBorderAttr(int key) {
        return this.zzYV2.getDirectShapeAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedBorderAttr(int key) {
        return this.zzYV2.fetchInheritedShapeAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setBorderAttr(int key, Object value) {
        this.zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz8H<Integer, Integer> getPossibleBorderKeys() {
        return zzYV0;
    }

    final byte[] zzZLX() throws Exception {
        return this.zzYUZ.zzZLX();
    }

    static {
        zzYV0.zzP(3, 4106);
        zzYV0.zzP(1, 4107);
        zzYV0.zzP(0, 4108);
        zzYV0.zzP(2, 4109);
    }
}

