/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zz1V;
import com.aspose.words.internal.zz2K;
import com.aspose.words.internal.zz8D;
import com.aspose.words.internal.zzC2;
import com.aspose.words.internal.zzQW;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zzYPE;
import com.aspose.words.zzZ0Q;
import com.aspose.words.zzZFF;
import com.aspose.words.zzZPD;
import com.aspose.words.zzZZR;

public class FormField
extends SpecialChar {
    private zzZZR zzZ5K;
    private Field zzZ5J;
    static String zzZ5I = zz2K.zzV('\u2002', 5);
    private static final zz1V zzVX = new zz1V("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZZR formFieldPr, zzZ0Q runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ5K = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZPD zzZPD2) {
        FormField formField = (FormField)super.zzZ(bl, zzZPD2);
        ((FormField)super.zzZ(bl, zzZPD2)).zzZ5K = (zzZZR)this.zzZ5K.zzyO();
        formField.zzZ5J = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZAT().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVX.zzWO(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzC2.zzI((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZAS().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzQW.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYPE.zzY((zz8D)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ5K.getName();
    }

    public void setName(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        this.zzZ5K.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzZ5K.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZT3() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZ5J == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZ5J = fieldChar.getField();
            }
        }
        return this.zzZ5J;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz2K.equals(string, zzZ5I)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZT2();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzQW.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQz(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ5K.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ5K.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ5K.zzZSY();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ5K.zzWJ(value);
    }

    public String getHelpText() {
        return this.zzZ5K.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ5K.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ5K.zzZSZ();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ5K.zzWK(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ5K.zzZT0();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ5K.zzWL(value);
    }

    public String getEntryMacro() {
        return this.zzZ5K.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ5K.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ5K.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ5K.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ5K.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ5K.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ5K.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ5K.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ5K.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ5K.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ5K.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ5K.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzFN(21);
            zzZFF.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZAS());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ5K.zzZSX();
    }

    public void setMaxLength(int value) {
        this.zzZ5K.zzKd(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ5K.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZZR zzZZR2 = this.zzZ5K;
        if (zzZZR2.contains(21070)) {
            return this.zzZ5K.zzZSR();
        }
        return this.zzZ5K.zzZSS();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ5K.zzKa(value);
    }

    final String zzZT2() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQz(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzC2.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZZR zzZZR2 = this.zzZ5K;
        if (zzZZR2.contains(21010)) {
            return this.zzZ5K.zzZST();
        }
        return this.zzZ5K.zzZSU();
    }

    public void setChecked(boolean value) {
        this.zzZ5K.zzWG(value);
    }

    public boolean getDefault() {
        return this.zzZ5K.zzZSU();
    }

    public void setDefault(boolean value) {
        this.zzZ5K.zzWH(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ5K.zzZSW();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ5K.zzWI(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ5K.zzZSV();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ5K.zzKc(zzZ.zzV(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZZR zzZT1() {
        return this.zzZ5K;
    }
}

